/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Entity.Projectiles;

import cofh.core.init.CoreParticles;
import com.c2h6s.etshtinker.init.etshtinkerParticleType;
import com.c2h6s.etshtinker.util.vecCalc;
import com.hoshino.cti.Entity.Projectiles.ItemProjectile;
import com.hoshino.cti.content.environmentSystem.EDamageSource;
import com.hoshino.cti.content.environmentSystem.EnvironmentalHandler;
import com.hoshino.cti.register.CtiItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class FallenStars
extends ItemProjectile {
    public final Item environmental;
    public float baseDamage;
    public int time = 0;
    public List<Entity> hitList = new ArrayList<Entity>(List.of());

    public FallenStars(EntityType<? extends ItemProjectile> type, Level p_37249_, Item item) {
        super(type, p_37249_);
        this.environmental = item;
    }

    @Override
    protected Item getDefaultItem() {
        return this.environmental;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)this.environmental);
    }

    @Override
    public void m_8119_() {
        ++this.time;
        Level world1 = this.m_9236_();
        if (this.time >= 2 && world1 instanceof ServerLevel) {
            double trackVelo;
            ServerLevel serverLevel = (ServerLevel)world1;
            Object initVec = this.m_20184_();
            initVec = initVec.m_82490_(Math.max(0.0, 1.0 - 0.025 * (double)this.time));
            LivingEntity living = vecCalc.getNearestLiEnt((Float)Float.valueOf(32.0f), (Entity)this, (Level)this.f_19853_);
            Vec3 vec3 = vecCalc.Entity1ToEntity2((Entity)this, (Entity)living);
            if (vecCalc.getMold((Vec3)vec3) != 0.0) {
                if (vecCalc.getMold((Vec3)vec3) <= 0.3) {
                    initVec = initVec.m_82490_(0.25);
                }
                trackVelo = Math.min(vecCalc.getMold((Vec3)vec3), 8.0 / vecCalc.getMold((Vec3)vec3));
                trackVelo = Math.min(trackVelo, 0.3);
                trackVelo = Math.max(vecCalc.getMold((Vec3)living.m_20184_()) + 0.35, trackVelo);
            } else {
                trackVelo = 0.0;
            }
            vec3 = vecCalc.getUnitizedVec3((Vec3)vec3).m_82490_(trackVelo);
            vec3 = initVec.m_82549_(vec3);
            if (vecCalc.getMold((Vec3)vec3) >= 1.5) {
                vec3.m_82490_(1.5 / vecCalc.getMold((Vec3)vec3));
            }
            if (vecCalc.getMold((Vec3)vec3) >= 0.1) {
                if (this.environmental == CtiItem.star_frozen.get()) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)CoreParticles.FROST.get()), this.m_20185_(), this.m_20186_() + 0.5 * (double)this.m_20206_(), this.m_20189_(), 8, 0.25, 0.25, 0.25, 0.0125);
                }
                if (this.environmental == CtiItem.star_pressure.get()) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5 * (double)this.m_20206_(), this.m_20189_(), 8, 0.25, 0.25, 0.25, 0.0125);
                }
                if (this.environmental == CtiItem.star_ionize.get()) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)etshtinkerParticleType.electric.get()), this.m_20185_(), this.m_20186_() + 0.5 * (double)this.m_20206_(), this.m_20189_(), 16, 0.3, 0.3, 0.3, 0.0125);
                }
                if (this.environmental == CtiItem.star_blaze.get()) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 0.5 * (double)this.m_20206_(), this.m_20189_(), 8, 0.25, 0.25, 0.25, 0.0125);
                }
            }
            this.m_20256_(vec3);
        }
        if (this.time > 300) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.m_6034_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
        List ls = this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.25));
        if (!ls.isEmpty()) {
            ls.addAll(this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(5.0)));
            for (LivingEntity living : ls) {
                if (living == null || living == this.m_37282_() || this.hitList.contains(living) || living instanceof Player) continue;
                Entity trackVelo = this.m_37282_();
                if (trackVelo instanceof Player) {
                    Player player = (Player)trackVelo;
                    living.f_19802_ = 0;
                    living.m_6469_(this.getSource(player, living), this.baseDamage);
                    if (world1 instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)world1;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, living.m_20185_(), living.m_20186_() + 0.5 * (double)living.m_20206_(), living.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                        if (this.environmental == CtiItem.star_frozen.get()) {
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)CoreParticles.FROST.get()), living.m_20185_(), living.m_20186_() + 0.5 * (double)living.m_20206_(), living.m_20189_(), 10, 0.05, 0.05, 0.05, 0.25);
                        }
                        if (this.environmental == CtiItem.star_pressure.get()) {
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, living.m_20185_(), living.m_20186_() + 0.5 * (double)living.m_20206_(), living.m_20189_(), 10, 0.05, 0.05, 0.05, 0.25);
                        }
                        if (this.environmental == CtiItem.star_ionize.get()) {
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)etshtinkerParticleType.electric.get()), living.m_20185_(), living.m_20186_() + 0.5 * (double)living.m_20206_(), living.m_20189_(), 10, 0.05, 0.05, 0.05, 0.25);
                        }
                        if (this.environmental == CtiItem.star_blaze.get()) {
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, living.m_20185_(), living.m_20186_() + 0.5 * (double)living.m_20206_(), living.m_20189_(), 10, 0.05, 0.05, 0.05, 0.25);
                        }
                    }
                }
                if (this.time >= 299) continue;
                this.time = 299;
            }
            Entity entity = this.m_37282_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.m_216990_(SoundEvents.f_11929_);
            }
            this.hitList.addAll(ls);
        }
        super.m_8119_();
    }

    public DamageSource getSource(Player player, @NotNull LivingEntity living) {
        CompoundTag nbt = living.getPersistentData();
        if (this.environmental == CtiItem.star_frozen.get()) {
            EnvironmentalHandler.addFrozenValue(living, 100);
            return EDamageSource.indirectFrozen(false, (Entity)player, 10);
        }
        if (this.environmental == CtiItem.star_ionize.get()) {
            EnvironmentalHandler.addIonizeValue(living, 100);
            return EDamageSource.indirectIonize(false, (Entity)player, 10);
        }
        if (this.environmental == CtiItem.star_pressure.get()) {
            EnvironmentalHandler.addPressureValue(living, 100);
            return EDamageSource.indirectPressure(false, (Entity)player, 10);
        }
        EnvironmentalHandler.addScorchValue(living, 100);
        return EDamageSource.indirectScorched(false, (Entity)player, 10);
    }
}

